﻿CREATE TABLE [dbo].[NB_Mentio] (
    [MentioID]   INT                IDENTITY (1, 1) NOT NULL,
    [SenderID]   INT                NOT NULL,
    [ReceiverID] INT                NOT NULL,
    [Timestamp]  DATETIMEOFFSET (7) NOT NULL,
    [CommentID]  INT                NULL,
    [ItemID]     INT                NULL,
    PRIMARY KEY CLUSTERED ([MentioID] ASC),
    CONSTRAINT [FK_NB_Mentio_NB_Comment] FOREIGN KEY ([CommentID]) REFERENCES [dbo].[NB_Comment] ([CommentID]),
    CONSTRAINT [FK_NB_Mentio_NB_Item] FOREIGN KEY ([ItemID]) REFERENCES [dbo].[NB_Item] ([ItemID]),
    CONSTRAINT [FK_NB_Mentio_PrincipalReceiver] FOREIGN KEY ([ReceiverID]) REFERENCES [dbo].[Principal] ([PrincipalID]),
    CONSTRAINT [FK_NB_Mentio_PrincipalSender] FOREIGN KEY ([SenderID]) REFERENCES [dbo].[Principal] ([PrincipalID])
);

